	clear all
	close all
	clc
	 
	wcT = 0.4*pi;	wsT = 0.6*pi;	Amin = 60;	Amax = 0.2;
	N = 19;
	[G, Z, P, alfa] = L_PHASE_IIR_HB(wcT, wsT, Amax, Amin, N);
	M = (N-1)/2;
	figure(1), PLOT_PZ_Z(Z, P)
	figure(2)
	subplot('position', [0.1 0.4 0.88 0.5]);
	wT = linspace(0, pi,1000);
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_HB(alfa, M, wT);
	Att = H_2_ATT(0.5*(S2 - S1));
	subplot('position', [0.08 0.4 0.90 0.5]);
	PLOT_ATT_Z(wT, Att, pi, 80)	, hold on
	axes('position',[0.20 0.52 0.3 0.2]);
	wTc = linspace(0, wcT,1000);
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_HB(alfa, M, wTc);
	Att = H_2_ATT(0.5*(S2 - S1));
	PLOT_ATT_Z_LS(wTc, Att, 3*10^-5)
	figure(3), subplot(3,1,1);
	[S1, S2] = L_PHASE_LATTICE_RICHARDS_HB(alfa, M, wTc);
	H = 0.5*(S2 - S1);
	Ph_error = unwrap(angle(H) + 9*wTc);  
	PLOT_DELTA_PHASE_Z(wTc, Ph_error, -3*10^-3, 3*10^-3)
	subplot(3,1,2)
	Taug = PZ_2_TG_Z(G, Z, P, wTc);
	PLOT_TG_Z(wTc, Taug, 14.4, 14.6)
